unit Sizemap;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, MapTest, OHMStuff;

type
  TSizeForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    XSize: TEdit;
    Label3: TLabel;
    YSize: TEdit;
    Label4: TLabel;
    ZSize: TEdit;
    Label5: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    SizeLabel: TLabel;
    procedure initstuff(Sender: TObject);
    procedure ChangeMapSize(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SizeForm: TSizeForm;

implementation

{$R *.DFM}

procedure TSizeForm.initstuff(Sender: TObject);
begin
     if MapEditor.MapDisplay.map<>nil then begin
        XSize.text:=IntToStr(MapEditor.MapDisplay.Map.Xdim);
        Ysize.text:=IntToStr(MapEditor.MapDisplay.Map.YDim);
        ZSize.text:=IntToStr(MapEditor.MapDisplay.Map.Zdim);
        ChangeMapSize(Sender);
     end
     else begin
         Xsize.text:='100';
         YSize.text:='100';
         ZSize.text:='1';
         ChangeMapSize(Sender);
     end;
end;

procedure TSizeForm.ChangeMapSize(Sender: TObject);
begin
     SizeLabel.Caption:=IntToStr(StrToInt(Xsize.text)*StrToInt(YSize.text)*StrToInt(ZSize.text));
end;

procedure TSizeForm.BitBtn1Click(Sender: TObject);

begin
     {Resize the map here}
     xdim:=StrToInt(Xsize.text);
     ydim:=StrtoInt(Ysize.text);
     zdim:=Strtoint(ZSize.text);
     if (xdim<=0) or (ydim<=0) or (zdim<=0) then
        Application.Messagebox('Object must have a positive size.','Error',0)
     else
         SizeForm.Modalresult:=mrOk;
end;

end.
